/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;

public abstract class WeakSet<T>
implements Set<T> {
    private static final boolean WARN_ON_ANONYMOUS_VALUE = SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode();
    private static final String WARNING_MESSAGE = "Added an anonymous class from a method or constructor.  Ghidra now has a policy of creating classes as top-level elements or creating inline classes where the field of the class is being declared.  This prevents accidental bugs whereby programmers add listeners to objects without maintaining a reference to that listener.\nSee SCR 8267 for an example.";
    protected WeakHashMap<T, T> weakHashStorage = new WeakHashMap();

    protected void maybeWarnAboutAnonymousValue(T t) {
        if (!WARN_ON_ANONYMOUS_VALUE) {
            return;
        }
        Class<?> clazz = t.getClass();
        if (!clazz.isAnonymousClass()) {
            return;
        }
        Method enclosingMethod = clazz.getEnclosingMethod();
        if (enclosingMethod != null) {
            Msg.debug((Object)this, (Object)("added an anonymous class created in a method: " + clazz.getName()), (Throwable)new Throwable());
            return;
        }
        Constructor<?> enclosingConstructor = clazz.getEnclosingConstructor();
        if (enclosingConstructor != null) {
            Msg.debug((Object)this, (Object)("Added an anonymous class from a method or constructor.  Ghidra now has a policy of creating classes as top-level elements or creating inline classes where the field of the class is being declared.  This prevents accidental bugs whereby programmers add listeners to objects without maintaining a reference to that listener.\nSee SCR 8267 for an example.\nClass name: " + clazz.getName()), (Throwable)new Throwable());
        }
    }

    @Override
    public abstract boolean add(T var1);

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract void clear();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    public abstract Collection<T> values();

    @Override
    public Object[] toArray() {
        return this.weakHashStorage.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.weakHashStorage.keySet().toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.weakHashStorage.keySet().containsAll(c);
    }

    @Override
    public abstract boolean addAll(Collection<? extends T> var1);

    @Override
    public abstract boolean retainAll(Collection<?> var1);

    @Override
    public abstract boolean removeAll(Collection<?> var1);

    @Override
    public abstract Stream<T> stream();
}

