/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jkiss.code.NotNull;
import org.jkiss.utils.Base64;

class PKCS1Util {
    private PKCS1Util() {
    }

    @NotNull
    public static PrivateKey loadPrivateKeyFromPKCS1(@NotNull String privateKeyPem) throws GeneralSecurityException, IOException {
        try (ASN1InputStream is = new ASN1InputStream(Base64.decode((String)privateKeyPem));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            if (seq.size() < 9) {
                throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
            }
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new RSAPrivateCrtKeySpec(PKCS1Util.getInteger(seq.getObjectAt(1)), PKCS1Util.getInteger(seq.getObjectAt(2)), PKCS1Util.getInteger(seq.getObjectAt(3)), PKCS1Util.getInteger(seq.getObjectAt(4)), PKCS1Util.getInteger(seq.getObjectAt(5)), PKCS1Util.getInteger(seq.getObjectAt(6)), PKCS1Util.getInteger(seq.getObjectAt(7)), PKCS1Util.getInteger(seq.getObjectAt(8))));
            return privateKey;
        }
    }

    @NotNull
    private static BigInteger getInteger(@NotNull ASN1Encodable encodable) {
        return ((ASN1Integer)encodable).getValue();
    }
}

