/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

class PlexusUtilsInjector
implements DependencyGraphTransformer {
    private static final String GID = "org.codehaus.plexus";
    private static final String AID = "plexus-utils";
    private static final String VER = "1.1";
    private static final String EXT = "jar";

    PlexusUtilsInjector() {
    }

    @Override
    public DependencyNode transformGraph(DependencyNode node2, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.findPlexusUtils(node2) == null) {
            DefaultArtifact pu = new DefaultArtifact(GID, AID, null, EXT, VER);
            DefaultDependencyNode child = new DefaultDependencyNode(new Dependency(pu, "runtime"));
            child.setRepositories(node2.getRepositories());
            child.setRequestContext(node2.getRequestContext());
            node2.getChildren().add(child);
        }
        return node2;
    }

    private DependencyNode findPlexusUtils(DependencyNode node2) {
        Artifact artifact = node2.getDependency().getArtifact();
        if (AID.equals(artifact.getArtifactId()) && GID.equals(artifact.getGroupId()) && EXT.equals(artifact.getExtension()) && "".equals(artifact.getClassifier())) {
            return node2;
        }
        for (DependencyNode child : node2.getChildren()) {
            DependencyNode result = this.findPlexusUtils(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

