/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ConnectorImpl;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.util.Map;

public class GenericAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_ADDRESS = "address";
    static final String ARG_TIMEOUT = "timeout";
    final TransportService transportService;
    Transport transport;

    private GenericAttachingConnector(TransportService ts, boolean addAddressArgument) {
        this.transportService = ts;
        this.transport = this.transportService::name;
        if (addAddressArgument) {
            this.addStringArgument(ARG_ADDRESS, this.getString("generic_attaching.address.label"), this.getString("generic_attaching.address"), "", true);
        }
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_attaching.timeout.label"), this.getString("generic_attaching.timeout"), "", false, 0, Integer.MAX_VALUE);
    }

    protected GenericAttachingConnector(TransportService ts) {
        this(ts, false);
    }

    public static GenericAttachingConnector create(TransportService ts) {
        return new GenericAttachingConnector(ts, true);
    }

    public VirtualMachine attach(String address, Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String ts = this.argument(ARG_TIMEOUT, args).value();
        int timeout2 = 0;
        if (ts.length() > 0) {
            timeout2 = Integer.decode(ts);
        }
        Connection connection = this.transportService.attach(address, timeout2, 0L);
        return VirtualMachineManagerImpl.virtualMachineManager().createVirtualMachine(connection);
    }

    @Override
    public VirtualMachine attach(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String address = this.argument(ARG_ADDRESS, args).value();
        return this.attach(address, args);
    }

    @Override
    public String name() {
        return this.transport.name() + "Attach";
    }

    @Override
    public String description() {
        return this.transportService.description();
    }

    @Override
    public Transport transport() {
        return this.transport;
    }
}

