/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.analysis.customization.console.ClassFinderFilter;
import com.intellij.analysis.customization.console.ClassLoggingConsoleFilterProviderKt;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/analysis/customization/console/ClassLoggingConsoleFilterProvider;", "Lcom/intellij/execution/filters/ConsoleFilterProvider;", "<init>", "()V", "getDefaultFilters", "", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/execution/filters/Filter;", "intellij.jvm.analysis.impl"})
public final class ClassLoggingConsoleFilterProvider
implements ConsoleFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!AdvancedSettings.Companion.getBoolean("process.console.output.to.find.class.names")) {
            Intrinsics.checkNotNullExpressionValue((Object)Filter.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return Filter.EMPTY_ARRAY;
        }
        Boolean hasLoggingSystems = (Boolean)ApplicationManager.getApplication().runReadAction(() -> ClassLoggingConsoleFilterProvider.getDefaultFilters$lambda$0(project));
        if (!hasLoggingSystems.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)Filter.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return Filter.EMPTY_ARRAY;
        }
        Filter[] filterArray = new Filter[1];
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        filterArray[0] = new ClassFinderFilter(project, globalSearchScope);
        return filterArray;
    }

    private static final Boolean getDefaultFilters$lambda$0(Project $project) {
        return JavaLibraryUtil.hasAnyLibraryJar((Project)$project, (Collection)ClassLoggingConsoleFilterProviderKt.access$getLOG_MAVEN$p());
    }
}

