/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCachedValue;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0005\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0006H\u0007\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0003*\u00020\u0001\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0001H\u0007\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u001a*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0006H\u0002\u001a:\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00062#\u0010\u001d\u001a\u001f\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001e\u00a2\u0006\u0002\b\u001fH\u0082\b\u001a\u001b\u0010 \u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b!H\u0007\u001a\u001b\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b!H\u0007\u001a\u001b\u0010#\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b!H\u0007\u001a\u0019\u0010$\u001a\u00020\u0001*\u00020\u00012\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b!H\u0007\u001a\u0019\u0010%\u001a\u00020\u0001*\u00020\u00012\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b!H\u0007\u001a\f\u0010&\u001a\u0004\u0018\u00010\u0001*\u00020\u0010\u001a\f\u0010'\u001a\u0004\u0018\u00010\u0001*\u00020\u0010\u001a\f\u0010(\u001a\u0004\u0018\u00010\u0001*\u00020\u0010\u001a\u0016\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010*\u001a\u00020\u0006H\u0007\u001am\u0010+\u001a\u0002H,\"\b\b\u0000\u0010,*\u00020-*\u00020\u00012\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,000/2\b\b\u0002\u00101\u001a\u00020\u00032\u0016\b\u0002\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0003\u0018\u0001032\u001a\u00104\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u000106\u0012\u0004\u0012\u0002H,05H\u0007\u00a2\u0006\u0002\u00107\u001a\u001c\u00108\u001a\u0004\u0018\u0001062\u0006\u00109\u001a\u00020\u00012\b\u0010:\u001a\u0004\u0018\u00010\u0012H\u0002\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006;"}, d2={"validOrNull", "Lcom/intellij/openapi/vfs/VirtualFile;", "isFile", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "readText", "", "writeText", "", "content", "readBytes", "", "writeBytes", "isTooLarge", "isTooLargeForIntellijSense", "toNioPathOrNull", "Ljava/nio/file/Path;", "findDocument", "Lcom/intellij/openapi/editor/Document;", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "originalFile", "originalFileOrSelf", "relativizeToClosestAncestor", "Lkotlin/Pair;", "relativePath", "getResolvedVirtualFile", "getChild", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "findFileOrDirectory", "Lorg/jetbrains/annotations/SystemIndependent;", "findFile", "findDirectory", "findOrCreateFile", "findOrCreateDirectory", "refreshAndFindVirtualFileOrDirectory", "refreshAndFindVirtualFile", "refreshAndFindVirtualDirectory", "resolveFromRootOrRelative", "absoluteOrRelativeFilePath", "getCachedValue", "T", "", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vfs/VirtualFileCachedValue;", "useSoftCache", "canCache", "Lkotlin/Function1;", "provider", "Lkotlin/Function2;", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/Key;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "loadText", "packageJsonFile", "packageJsonDocument", "intellij.platform.core"})
@JvmName(name="VirtualFileUtil")
@SourceDebugExtension(value={"SMAP\nVirtualFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,314:1\n118#1,4:321\n122#1,12:329\n118#1,4:341\n122#1,12:349\n118#1,4:361\n122#1,12:369\n1#2:315\n19#3:316\n1563#4:317\n1634#4,3:318\n1563#4:325\n1634#4,3:326\n1563#4:345\n1634#4,3:346\n1563#4:365\n1634#4,3:366\n23#5:381\n*S KotlinDebug\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n*L\n138#1:321,4\n138#1:329,12\n171#1:341,4\n171#1:349,12\n189#1:361,4\n189#1:369,12\n86#1:316\n121#1:317\n121#1:318,3\n138#1:325\n138#1:326,3\n171#1:345\n171#1:346,3\n189#1:365\n189#1:366,3\n260#1:381\n*E\n"})
public final class VirtualFileUtil {
    @Nullable
    public static final VirtualFile validOrNull(@NotNull VirtualFile $this$validOrNull) {
        Intrinsics.checkNotNullParameter($this$validOrNull, "<this>");
        return $this$validOrNull.isValid() ? $this$validOrNull : null;
    }

    public static final boolean isFile(@NotNull VirtualFile $this$isFile) {
        Intrinsics.checkNotNullParameter($this$isFile, "<this>");
        return $this$isFile.isValid() && !$this$isFile.isDirectory();
    }

    @NotNull
    public static final String readText(@NotNull VirtualFile $this$readText) {
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        String string = VfsUtilCore.loadText($this$readText);
        Intrinsics.checkNotNullExpressionValue(string, "loadText(...)");
        return string;
    }

    @RequiresWriteLock
    public static final void writeText(@NotNull VirtualFile $this$writeText, @NotNull String content) {
        Intrinsics.checkNotNullParameter($this$writeText, "<this>");
        Intrinsics.checkNotNullParameter(content, "content");
        VfsUtilCore.saveText($this$writeText, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(@NotNull VirtualFile $this$readBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        Closeable closeable = $this$readBytes.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            byArray = ByteStreamsKt.readBytes(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    @RequiresWriteLock
    public static final void writeBytes(@NotNull VirtualFile $this$writeBytes, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter($this$writeBytes, "<this>");
        Intrinsics.checkNotNullParameter(content, "content");
        $this$writeBytes.setBinaryContent(content);
    }

    public static final boolean isTooLarge(@NotNull VirtualFile $this$isTooLarge) {
        Intrinsics.checkNotNullParameter($this$isTooLarge, "<this>");
        return FileSizeLimit.Companion.isTooLarge($this$isTooLarge.getLength(), $this$isTooLarge.getExtension());
    }

    public static final boolean isTooLargeForIntellijSense(@NotNull VirtualFile $this$isTooLargeForIntellijSense) {
        Intrinsics.checkNotNullParameter($this$isTooLargeForIntellijSense, "<this>");
        int maxFileSize = FileSizeLimit.Companion.getIntellisenseLimit($this$isTooLargeForIntellijSense.getExtension());
        return $this$isTooLargeForIntellijSense.getLength() > (long)maxFileSize;
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull VirtualFile $this$toNioPathOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter($this$toNioPathOrNull, "<this>");
        Object object2 = $this$toNioPathOrNull;
        try {
            VirtualFile $this$toNioPathOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl($this$toNioPathOrNull_u24lambda_u240.toNioPath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl(object2) ? null : object2);
    }

    @RequiresReadLock
    @Nullable
    public static final Document findDocument(@NotNull VirtualFile $this$findDocument) {
        Intrinsics.checkNotNullParameter($this$findDocument, "<this>");
        return FileDocumentManager.getInstance().getDocument($this$findDocument);
    }

    @RequiresReadLock
    @Nullable
    public static final PsiFile findPsiFile(@NotNull VirtualFile $this$findPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$findPsiFile, "<this>");
        Intrinsics.checkNotNullParameter(project, "project");
        return PsiManager.getInstance(project).findFile($this$findPsiFile);
    }

    @Nullable
    public static final VirtualFile originalFile(@NotNull VirtualFile $this$originalFile) {
        Intrinsics.checkNotNullParameter($this$originalFile, "<this>");
        VirtualFile $this$asSafely$iv = $this$originalFile;
        boolean $i$f$asSafely = false;
        VirtualFile virtualFile = $this$asSafely$iv;
        if (!(virtualFile instanceof LightVirtualFileBase)) {
            virtualFile = null;
        }
        LightVirtualFileBase lightVirtualFileBase = (LightVirtualFileBase)virtualFile;
        return lightVirtualFileBase != null ? lightVirtualFileBase.getOriginalFile() : null;
    }

    @NotNull
    public static final VirtualFile originalFileOrSelf(@NotNull VirtualFile $this$originalFileOrSelf) {
        Intrinsics.checkNotNullParameter($this$originalFileOrSelf, "<this>");
        VirtualFile virtualFile = VirtualFileUtil.originalFile($this$originalFileOrSelf);
        if (virtualFile == null) {
            virtualFile = $this$originalFileOrSelf;
        }
        return virtualFile;
    }

    private static final Pair<VirtualFile, Path> relativizeToClosestAncestor(VirtualFile $this$relativizeToClosestAncestor, String relativePath) {
        Path basePath = Paths.get($this$relativizeToClosestAncestor.getPath(), new String[0]);
        Intrinsics.checkNotNull(basePath);
        Pair<Path, Path> pair = NioPathUtil.relativizeToClosestAncestor(basePath, relativePath);
        Path normalizedBasePath = pair.component1();
        Path normalizedRelativePath = pair.component2();
        Ref.ObjectRef baseVirtualFile = new Ref.ObjectRef();
        baseVirtualFile.element = $this$relativizeToClosestAncestor;
        int n = basePath.getNameCount() - normalizedBasePath.getNameCount();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (((VirtualFile)baseVirtualFile.element).getParent() == null) {
                Object cfr_ignored_0 = baseVirtualFile.element;
                Ref.ObjectRef objectRef = baseVirtualFile;
                boolean bl2 = false;
                Ref.ObjectRef objectRef2 = objectRef;
                String string = StringsKt.trimMargin$default("\n        |Cannot resolve base virtual file for " + baseVirtualFile.element + "\n        |  basePath = " + $this$relativizeToClosestAncestor.getPath() + "\n        |  relativePath = " + relativePath + "\n      ", null, 1, null);
                throw new IllegalStateException(string.toString());
            }
            baseVirtualFile.element = baseVirtualFile.element;
        }
        return TuplesKt.to(baseVirtualFile.element, normalizedRelativePath);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getResolvedVirtualFile(VirtualFile $this$getResolvedVirtualFile, String relativePath, Function3<? super VirtualFile, ? super String, ? super Boolean, ? extends VirtualFile> getChild) {
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile, relativePath);
        VirtualFile baseVirtualFile = pair.component1();
        Path normalizedRelativePath = pair.component2();
        VirtualFile virtualFile = baseVirtualFile;
        if (((CharSequence)((Object)normalizedRelativePath).toString()).length() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = normalizedRelativePath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection.add(it.toString());
            }
            List names = (List)destination$iv$iv;
            Iterator iterator2 = ((Iterable)names).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                String name = (String)iterator2.next();
                if (!virtualFile.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile + "\n          |  basePath = " + $this$getResolvedVirtualFile.getPath() + "\n          |  relativePath = " + relativePath + "\n        ", null, 1, null));
                }
                virtualFile = getChild.invoke(virtualFile, name, (Boolean)(i == CollectionsKt.getLastIndex(names) ? 1 : 0));
            }
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFileOrDirectory(@NotNull VirtualFile $this$findFileOrDirectory, @NotNull String relativePath) {
        void $this$getResolvedVirtualFile$iv;
        Intrinsics.checkNotNullParameter($this$findFileOrDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = $this$findFileOrDirectory;
        String relativePath$iv = relativePath;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor((VirtualFile)$this$getResolvedVirtualFile$iv, relativePath$iv);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = ((Iterable)names$iv).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void name;
                int i$iv = n++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath$iv + "\n        ", null, 1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex(names$iv)) {
                    // empty if block
                }
                String string = name$iv;
                VirtualFile $this$findFileOrDirectory_u24lambda_u240 = virtualFile$iv;
                boolean bl = false;
                if ($this$findFileOrDirectory_u24lambda_u240.findChild((String)name) != null) continue;
                return null;
            }
        }
        return virtualFile$iv;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFile(@NotNull VirtualFile $this$findFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findFile, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (!VirtualFileUtil.isFile(file)) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected file instead of directory: " + file + "\n      |  basePath = " + $this$findFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return file;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findDirectory(@NotNull VirtualFile $this$findDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findDirectory, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        if (!directory.isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return directory;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateFile(@NotNull VirtualFile $this$findOrCreateFile, @NotNull String relativePath) {
        VirtualFile file;
        void $this$getResolvedVirtualFile$iv;
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = $this$findOrCreateFile;
        String relativePath$iv = relativePath;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor((VirtualFile)$this$getResolvedVirtualFile$iv, relativePath$iv);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = ((Iterable)names$iv).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void name;
                int i$iv = n++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath$iv + "\n        ", null, 1, null));
                }
                boolean bl = i$iv == CollectionsKt.getLastIndex(names$iv);
                String string = name$iv;
                VirtualFile $this$findOrCreateFile_u24lambda_u240 = virtualFile$iv;
                boolean bl2 = false;
                VirtualFile virtualFile2 = $this$findOrCreateFile_u24lambda_u240.findChild((String)name);
                if (virtualFile2 == null) {
                    void isLast;
                    if (isLast == true) {
                        VirtualFile virtualFile3 = $this$findOrCreateFile_u24lambda_u240.createChildData($this$findOrCreateFile_u24lambda_u240.getFileSystem(), (String)name);
                        virtualFile2 = virtualFile3;
                        Intrinsics.checkNotNullExpressionValue(virtualFile3, "createChildData(...)");
                    } else {
                        VirtualFile virtualFile4 = $this$findOrCreateFile_u24lambda_u240.createChildDirectory($this$findOrCreateFile_u24lambda_u240.getFileSystem(), (String)name);
                        virtualFile2 = virtualFile4;
                        Intrinsics.checkNotNullExpressionValue(virtualFile4, "createChildDirectory(...)");
                    }
                }
                virtualFile$iv = virtualFile2;
            }
        }
        if (!VirtualFileUtil.isFile(file = virtualFile$iv)) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected file instead of directory: " + file + "\n      |  basePath = " + $this$findOrCreateFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateDirectory(@NotNull VirtualFile $this$findOrCreateDirectory, @NotNull String relativePath) {
        VirtualFile directory;
        void $this$getResolvedVirtualFile$iv;
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = $this$findOrCreateDirectory;
        String relativePath$iv = relativePath;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor((VirtualFile)$this$getResolvedVirtualFile$iv, relativePath$iv);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = ((Iterable)names$iv).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void name;
                int i$iv = n++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath$iv + "\n        ", null, 1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex(names$iv)) {
                    // empty if block
                }
                String string = name$iv;
                VirtualFile $this$findOrCreateDirectory_u24lambda_u240 = virtualFile$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = $this$findOrCreateDirectory_u24lambda_u240.findChild((String)name);
                if (virtualFile2 == null) {
                    VirtualFile virtualFile3 = $this$findOrCreateDirectory_u24lambda_u240.createChildDirectory($this$findOrCreateDirectory_u24lambda_u240.getFileSystem(), (String)name);
                    virtualFile2 = virtualFile3;
                    Intrinsics.checkNotNullExpressionValue(virtualFile3, "createChildDirectory(...)");
                }
                virtualFile$iv = virtualFile2;
            }
        }
        if (!(directory = virtualFile$iv).isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findOrCreateDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return directory;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFileOrDirectory(@NotNull Path $this$refreshAndFindVirtualFileOrDirectory) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualFileOrDirectory, "<this>");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue(virtualFileManager, "getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        return fileManager.refreshAndFindFileByNioPath($this$refreshAndFindVirtualFileOrDirectory);
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFile(@NotNull Path $this$refreshAndFindVirtualFile) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualFile, "<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (!VirtualFileUtil.isFile(file)) {
            throw new IOException("Expected file instead of directory: " + $this$refreshAndFindVirtualFile);
        }
        return file;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualDirectory(@NotNull Path $this$refreshAndFindVirtualDirectory) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualDirectory, "<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualDirectory);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (!file.isDirectory()) {
            throw new IOException("Expected directory instead of file: " + $this$refreshAndFindVirtualDirectory);
        }
        return file;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static final VirtualFile resolveFromRootOrRelative(@NotNull VirtualFile $this$resolveFromRootOrRelative, @NotNull String absoluteOrRelativeFilePath) {
        Intrinsics.checkNotNullParameter($this$resolveFromRootOrRelative, "<this>");
        Intrinsics.checkNotNullParameter(absoluteOrRelativeFilePath, "absoluteOrRelativeFilePath");
        VirtualFile virtualFile = $this$resolveFromRootOrRelative.getFileSystem().findFileByPath(absoluteOrRelativeFilePath);
        if (virtualFile == null) {
            virtualFile = $this$resolveFromRootOrRelative.findFileByRelativePath(absoluteOrRelativeFilePath);
        }
        return virtualFile;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final <T> T getCachedValue(@NotNull VirtualFile $this$getCachedValue, @NotNull Key<VirtualFileCachedValue<T>> key, boolean useSoftCache, @Nullable Function1<? super VirtualFile, Boolean> canCache, @NotNull Function2<? super VirtualFile, ? super CharSequence, ? extends T> provider) {
        T data;
        Intrinsics.checkNotNullParameter($this$getCachedValue, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(provider, "provider");
        if (!$this$getCachedValue.isValid() && ApplicationManager.getApplication().isReadAccessAllowed()) {
            VirtualFile $this$thisLogger$iv = $this$getCachedValue;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VirtualFile.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error(new InvalidVirtualFileAccessException($this$getCachedValue));
            return provider.invoke($this$getCachedValue, null);
        }
        ProgressManager.checkCanceled();
        Document document = FileDocumentManager.getInstance().getCachedDocument($this$getCachedValue);
        VirtualFileCachedValue<T> cached = key.get($this$getCachedValue);
        Document document2 = document;
        long documentModificationStamp = document2 != null ? document2.getModificationStamp() : -1L;
        VirtualFileCachedValue<T> virtualFileCachedValue = cached;
        Object object = data = virtualFileCachedValue != null ? virtualFileCachedValue.getData$intellij_platform_core() : null;
        if (cached == null || data == null || cached.getDocumentModificationStamp$intellij_platform_core() != documentModificationStamp || cached.getFileModificationStamp$intellij_platform_core() != $this$getCachedValue.getModificationStamp()) {
            CharSequence text = VirtualFileUtil.loadText($this$getCachedValue, document);
            data = provider.invoke($this$getCachedValue, text);
            cached = new VirtualFileCachedValue<T>(data, useSoftCache, $this$getCachedValue.getModificationStamp(), documentModificationStamp);
            Function1<? super VirtualFile, Boolean> function1 = canCache;
            if (!(function1 != null ? !function1.invoke($this$getCachedValue).booleanValue() : false)) {
                key.set($this$getCachedValue, cached);
            }
        }
        return data;
    }

    public static /* synthetic */ Object getCachedValue$default(VirtualFile virtualFile, Key key, boolean bl, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return VirtualFileUtil.getCachedValue(virtualFile, key, bl, function1, function2);
    }

    private static final CharSequence loadText(VirtualFile packageJsonFile, Document packageJsonDocument) {
        CharSequence charSequence;
        if (packageJsonDocument != null) {
            return packageJsonDocument.getImmutableCharSequence();
        }
        try {
            charSequence = VfsUtilCore.loadText(packageJsonFile);
        }
        catch (IOException e) {
            charSequence = null;
        }
        return charSequence;
    }
}

