/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.changes;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0007J)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/vcs/changes/ChangesUtil;", "", "<init>", "()V", "CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY", "Lcom/intellij/util/containers/HashingStrategy;", "Lcom/intellij/openapi/vcs/FilePath;", "getFilePath", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getAfterPath", "getBeforePath", "equalsCaseSensitive", "", "path1", "path2", "getNavigatableArray", "", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Iterable;)[Lcom/intellij/pom/Navigatable;", "iteratePathsCaseSensitive", "Lcom/intellij/util/containers/JBIterable;", "isMergeConflict", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "intellij.platform.vcs.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChangesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesUtil.kt\ncom/intellij/platform/vcs/changes/ChangesUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class ChangesUtil {
    @NotNull
    public static final ChangesUtil INSTANCE = new ChangesUtil();
    @JvmField
    @NotNull
    public static final HashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = (HashingStrategy)new HashingStrategy<FilePath>(){

        public int hashCode(FilePath path) {
            int n;
            if (path != null) {
                Object[] objectArray = new Object[]{path.getPath(), path.isDirectory()};
                n = Objects.hash(objectArray);
            } else {
                n = 0;
            }
            return n;
        }

        public boolean equals(FilePath path1, FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.isDirectory() == path2.isDirectory() && Intrinsics.areEqual((Object)path1.getPath(), (Object)path2.getPath());
        }
    };

    private ChangesUtil() {
    }

    @JvmStatic
    @NotNull
    public static final FilePath getFilePath(@NotNull Change change) {
        ContentRevision revision;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ContentRevision contentRevision = change.getAfterRevision();
        if (contentRevision == null) {
            contentRevision = change.getBeforeRevision();
        }
        if ((revision = contentRevision) == null) {
            boolean bl = false;
            String string = "Change " + change + " doesn't have before or after revisions";
            throw new IllegalArgumentException(string.toString());
        }
        FilePath filePath = revision.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFile(...)");
        return filePath;
    }

    @JvmStatic
    @Nullable
    public static final FilePath getAfterPath(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ContentRevision contentRevision = change.getAfterRevision();
        return contentRevision != null ? contentRevision.getFile() : null;
    }

    @JvmStatic
    @Nullable
    public static final FilePath getBeforePath(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ContentRevision contentRevision = change.getBeforeRevision();
        return contentRevision != null ? contentRevision.getFile() : null;
    }

    @JvmStatic
    public static final boolean equalsCaseSensitive(@Nullable FilePath path1, @Nullable FilePath path2) {
        return CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)path1, (Object)path2);
    }

    @JvmStatic
    @NotNull
    public static final Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull Iterable<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection collection = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(files), ChangesUtil::getNavigatableArray$lambda$0), arg_0 -> ChangesUtil.getNavigatableArray$lambda$1(project, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)Navigatable.EMPTY_NAVIGATABLE_ARRAY, (String)"EMPTY_NAVIGATABLE_ARRAY");
        return (Navigatable[])UtilKt.toArray((Collection)collection, (Object[])Navigatable.EMPTY_NAVIGATABLE_ARRAY);
    }

    @JvmStatic
    @NotNull
    public static final JBIterable<FilePath> iteratePathsCaseSensitive(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        FilePath beforePath = ChangesUtil.getBeforePath(change);
        FilePath afterPath = ChangesUtil.getAfterPath(change);
        if (ChangesUtil.equalsCaseSensitive(beforePath, afterPath)) {
            JBIterable jBIterable = JBIterable.of((Object)beforePath);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }
        Object[] objectArray = new FilePath[]{beforePath, afterPath};
        JBIterable jBIterable = JBIterable.of((Object[])objectArray).filterNotNull();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterNotNull(...)");
        return jBIterable;
    }

    @JvmStatic
    public static final boolean isMergeConflict(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        FileStatus fileStatus = change.getFileStatus();
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
        FileStatus status = fileStatus;
        return ChangesUtil.isMergeConflict(status);
    }

    @JvmStatic
    public static final boolean isMergeConflict(@NotNull FileStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
    }

    private static final boolean getNavigatableArray$lambda$0(VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.isDirectory();
    }

    private static final OpenFileDescriptor getNavigatableArray$lambda$1(Project $project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new OpenFileDescriptor($project, file);
    }
}

