/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.eclipse.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.conversion.AbstractIdeaSpecificSettings;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;

final class JpsIdeaSpecificSettings
extends AbstractIdeaSpecificSettings<JpsModule, String, JpsSdkType<?>> {
    private final JpsMacroExpander myExpander;

    JpsIdeaSpecificSettings(JpsMacroExpander expander) {
        this.myExpander = expander;
    }

    protected void readLibraryLevels(Element root, @NotNull Map<String, String> levels) {
        Element levelsElement;
        if (levels == null) {
            JpsIdeaSpecificSettings.$$$reportNull$$$0(0);
        }
        if ((levelsElement = root.getChild("levels")) != null) {
            for (Element element : levelsElement.getChildren("level")) {
                String libName = element.getAttributeValue("name");
                String libLevel = element.getAttributeValue("value");
                if (libName == null || libLevel == null) continue;
                levels.put(libName, libLevel);
            }
        }
    }

    protected String[] getEntries(JpsModule model) {
        return ArrayUtilRt.toStringArray((Collection)model.getContentRootsList().getUrls());
    }

    protected String createContentEntry(JpsModule model, String url) {
        model.getContentRootsList().addUrl(url);
        return url;
    }

    protected void setupLibraryRoots(Element root, JpsModule model) {
    }

    protected void setupJdk(Element root, JpsModule model, @Nullable JpsSdkType<?> projectSdkType) {
        String inheritJdk = root.getAttributeValue("inheritJdk");
        JpsDependenciesList dependenciesList = model.getDependenciesList();
        if (inheritJdk != null && Boolean.parseBoolean(inheritJdk)) {
            dependenciesList.addSdkDependency((JpsSdkType)(projectSdkType != null ? projectSdkType : JpsJavaSdkType.INSTANCE));
        } else {
            String jdkName = root.getAttributeValue("jdk");
            if (jdkName != null) {
                String jdkType = root.getAttributeValue("jdk_type");
                JpsSdkType sdkType = null;
                if (jdkType != null) {
                    sdkType = JpsSdkTableSerializer.getSdkType((String)jdkType);
                }
                if (sdkType == null) {
                    sdkType = JpsJavaSdkType.INSTANCE;
                }
                dependenciesList.addSdkDependency(sdkType);
                JpsSdkTableSerializer.setSdkReference((JpsSdkReferencesTable)model.getSdkReferencesTable(), (String)jdkName, (JpsSdkType)sdkType);
                if (sdkType instanceof JpsJavaSdkTypeWrapper) {
                    dependenciesList.addSdkDependency((JpsSdkType)JpsJavaSdkType.INSTANCE);
                }
            }
        }
    }

    protected void setupCompilerOutputs(Element root, JpsModule model) {
        String inheritedOutput;
        JpsJavaModuleExtension extension = JpsIdeaSpecificSettings.getService().getOrCreateModuleExtension(model);
        Element testOutputElement = root.getChild("output-test");
        if (testOutputElement != null) {
            extension.setTestOutputUrl(testOutputElement.getAttributeValue("url"));
        }
        if ((inheritedOutput = root.getAttributeValue("inherit-compiler-output")) != null && Boolean.parseBoolean(inheritedOutput)) {
            extension.setInheritOutput(true);
        }
        extension.setExcludeOutput(root.getChild("exclude-output") != null);
    }

    protected void readLanguageLevel(Element root, JpsModule model) {
        String languageLevel = root.getAttributeValue("LANGUAGE_LEVEL");
        JpsJavaModuleExtension extension = JpsIdeaSpecificSettings.getService().getOrCreateModuleExtension(model);
        if (languageLevel != null) {
            extension.setLanguageLevel(LanguageLevel.valueOf((String)languageLevel));
        }
    }

    protected void expandElement(Element root, JpsModule model) {
        this.myExpander.substitute(root, SystemInfo.isFileSystemCaseSensitive);
    }

    protected void overrideModulesScopes(Element root, JpsModule model) {
    }

    public void readContentEntry(Element root, String contentUrl, JpsModule model) {
        for (Element o : root.getChildren("testFolder")) {
            String url = o.getAttributeValue("url");
            JpsModuleSourceRoot folderToBeTest = null;
            for (JpsModuleSourceRoot folder : model.getSourceRoots()) {
                if (!Comparing.strEqual((String)folder.getUrl(), (String)url)) continue;
                folderToBeTest = folder;
                break;
            }
            if (folderToBeTest != null) {
                model.removeSourceRoot(folderToBeTest.getUrl(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
            }
            model.addSourceRoot(url, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        }
        for (Element o : root.getChildren("excludeFolder")) {
            String excludeUrl = o.getAttributeValue("url");
            if (!FileUtil.isAncestor((File)new File(contentUrl), (File)new File(excludeUrl), (boolean)false)) continue;
            model.getExcludeRootsList().addUrl(excludeUrl);
        }
        block3: for (Element ppElement : root.getChildren("packagePrefix")) {
            String prefix = ppElement.getAttributeValue("value");
            String url = ppElement.getAttributeValue("url");
            for (JpsModuleSourceRoot sourceRoot : model.getSourceRoots()) {
                if (!Comparing.strEqual((String)sourceRoot.getUrl(), (String)url)) continue;
                JpsElement properties = sourceRoot.getProperties();
                if (!(properties instanceof JavaSourceRootProperties)) continue block3;
                ((JavaSourceRootProperties)properties).setPackagePrefix(prefix);
                continue block3;
            }
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "levels", "org/jetbrains/jps/eclipse/model/JpsIdeaSpecificSettings", "readLibraryLevels"));
    }
}

